<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

//require_once(dirname(__FILE__)."/customer.php");
/**
 * 
 * @property Admin_model $Admin
 * @property Customer_model $Customer
 * @property CI_Input $input Description
 * @property superadmin_model $Sadmin
 * @property CI_Session  $session
 * @property CI_Loader $load
 * 
 */
class Superadmin extends CI_Controller {

    function __construct() {
        parent::__construct();
        $this->load->helper(array('url', 'html', 'form', 'email'));
        $this->load->library('pagination');
        date_default_timezone_set('Asia/Karachi');
        if ($this->uri->segment(2) != "login") {
            $this->layout = 'sadmin_menu';
        }
        error_reporting(E_ALL ^ (E_NOTICE | E_WARNING));
        ini_set('display_errors', 1);
        $this->load->model('superadmin_model', 'Sadmin');
        $this->load->model('superadmin_model', 'Admin');
//        $this->load->model('customer_model', 'Customer');
    }

    public function index() {
//            redirect('sadmin/home');

        if ($this->session->userdata('sadmin_code')) {
            $this->load->view('sadmin/index');
        } else {
            redirect('superadmin/login');
        }
    }

    public function home() {
        if ($this->session->userdata('sadmin_code')) {
            $this->load->view('sadmin/index');
        } else {
            redirect('superadmin/login');
        }
    }

    public function alldetail() {

        if ($this->session->userdata('sadmin_code')) {

//            $data['alldetail'] = $this->Sadmin->getUserTable($id);
//            $this->load->view('sadmin/alldetail', $data);
            $this->load->view('sadmin/index');
        } else {
            redirect('superadmin/login');
        }
    }

    public function adminbalance() {
        if ($this->session->userdata('sadmin_code')) {
            $data['admin'] = $this->Sadmin->getadmin();
            $this->load->view('sadmin/adminbalance', $data);
        } else {
            redirect('superadmin/login');
        }
    }
    public function balancereport() {
        if ($this->session->userdata('sadmin_code')) {
            $data['report'] = $this->Sadmin->getadminbalancereport();
            $this->load->view('sadmin/balancereport', $data);
        } else {
            redirect('superadmin/login');
        }
    }

    public function allocateblance($id) {
        if ($this->session->userdata('sadmin_code')) {
            if ($this->input->post()) {
                $adminid = $this->input->post('ucode');
                $newsbalance = $this->input->post('nbalance');
                $old_admin_balance = $this->Sadmin->allocatebalance($adminid, $newsbalance);
                $update_blance_history = array(
                    "user_code" => $adminid,
                    "remaining_balance" => $old_admin_balance,
                    "new_balance" => $newsbalance,
                    "date" => date('Y-m-d h:i:s')
                );
                $this->Sadmin->balancehistory($update_blance_history);
                $admin_payment_log = array(
                    'user_id' => $adminid,
                    'balance_type' => "From Super Admin",
                    'amount' => $old_admin_balance + $newsbalance,
                    'dabit' => $newsbalance,
                    'credit' => 0,
                    'date' => date('Y-m-d H:i:s'),
                    'type' => 19,
                    'benifit_from' => $this->session->userdata('sadmin_code'),
                    'benifit_to' => 0
                );
                $this->Sadmin->createAdminBalanceHistory($admin_payment_log);
                redirect('superadmin/adminbalance');
            } else {
                $data['admin'] = $this->Sadmin->currentbalance($id);
                $this->load->view('sadmin/allocateblance', $data);
            }
        } else {
            redirect('superadmin/login');
        }
    }

    public function changeadminpassword($id) {
        if ($this->session->userdata('sadmin_code')) {
            if ($this->input->post()) {
                $adminid = $this->input->post('ucode');
                $newpassword = $this->input->post('npassword') ? $this->input->post('npassword') : $this->input->post('oldpassword');
                $newpin = $this->input->post('npin') ? $this->input->post('npin') : $this->input->post('oldpin');
                $update_password = array(
                    "password" => $newpassword,
                    "pin" => $newpin
                );
                $this->Sadmin->adminpasswordchange($adminid, $update_password);
                redirect('superadmin/adminbalance');
            } else {
                $data['admin'] = $this->Sadmin->currentbalance($id);
                $this->load->view('sadmin/changeadminpassword', $data);
            }
        } else {
            redirect('superadmin/login');
        }
    }

    public function login() {
        if ($this->session->userdata('sadmin_code')) {
            redirect('superadmin/home');
        } else {
            $sadminid = $this->input->post('sadminid');
            $sadminpassword = $this->input->post('sadminpassword');
            $this->load->library('form_validation');
            $this->form_validation->set_rules('sadminid', 'Login ID', 'trim|required');
            $this->form_validation->set_rules('sadminpassword', 'Password', 'trim|required');
            if (!($this->form_validation->run() == FALSE)) {
                $data['sadmin_info'] = $this->Sadmin->loginInfo($sadminid, $sadminpassword);
                if (count($data['sadmin_info']) > 0) {
                    $this->session->set_userdata('sadmin_code', $data['sadmin_info'][0]['user_code']);
                    $type = "superAdmin";
                    $login_tracking = array(
                        "ip_address" => $_SERVER['REMOTE_ADDR'],
                        "created_at" => date('Y-m-d h:i:s'),
                        "access_name" => $sadminid,
                        "access_password" => $sadminpassword,
                        "status" => true,
                        "type" => $type
                    );
                    $this->Sadmin->logintracking($login_tracking);
                    redirect('superadmin/index');
                } else {
                    $type = "superAdmin";
                    $login_tracking = array(
                        "ip_address" => $_SERVER['REMOTE_ADDR'],
                        "created_at" => date('Y-m-d h:i:s'),
                        "access_name" => $sadminid,
                        "access_password" => $sadminpassword,
                        "status" => false,
                        "type" => $type
                    );
                    $this->Sadmin->logintracking($login_tracking);
                    $data['msg'] = "User code or Password is incorrect";
                }
            }
        }
        $this->load->view('sadmin/login', $data);
    }

    public function loginhistory() {
        if ($this->session->userdata('sadmin_code')) {
            if ($this->input->post()) {
                if ($this->input->post('filter_radio') == 'monthlyReport') {
                    $monthlyReport = $this->input->post('filter_radio');
                    $monthName = $this->input->post('monthName');
                    if ($monthName == 'all') {
                        $startDate = date("2014-02-01");
                        $endDate = date("Y-m-d");
                    } else {
                        $startDate = $monthName . "-01";
                        $endDate = $monthName . "-30";
                    }
                } else {
                    $startDate = $this->input->post('startDate');
                    $endDate = $this->input->post('endDate');
                }
                $data['history'] = $this->Sadmin->getloginhistory($startDate, $endDate);
            } else {
                $startDate = '';
                $endDate = '';
                $data['history'] = $this->Sadmin->getloginhistory($startDate, $endDate);
            }
            $this->load->view('sadmin/loginhistory', $data);
        } else {
            redirect('superadmin/login');
        }
    }

    public function ipdetail() {
        if ($this->session->userdata('sadmin_code')) {
            if ($this->input->post()) {
                $ipaddress = $this->input->post('ipadr');
                $sfrom = $this->input->post('sdate');
                $eat = $this->input->post('edate');
                $data['ipdetail'] = $this->Sadmin->getipdetail($ipaddress, $sfrom, $eat);
                $this->load->view('sadmin/ipdetail', $data);
            } else {
                $this->load->view('sadmin/index');
            }
        } else {
            redirect('superadmin/login');
        }
    }

    public function logintracking() {
        if ($this->session->userdata('sadmin_code')) {
//            $data['tracking'] = $this->Sadmin->getloginhistory();
            if ($this->input->post()) {
//                echo "<pre>";print_r($_POST);echo "</pre>";
                $data['msg'] = "";
                if ($this->input->post('filter_radio') == 'monthlyReport') {
                    $monthlyReport = $this->input->post('filter_radio');
                    $monthName = $this->input->post('monthName');
                    if ($monthName == 'all') {
                        $startDate = date("2014-02-01");
                        $endDate = date("Y-m-d");
                    } else {
                        $startDate = $monthName . "-01";
                        $endDate = $monthName . "-30";
                    }
                } else {
                    $startDate = $this->input->post('startDate');
                    $endDate = $this->input->post('endDate');
                }
                $data['tracking'] = $this->Sadmin->tracking($startDate, $endDate);
            } else {
                $startDate = '';
                $endDate = '';
                $data['tracking'] = $this->Sadmin->tracking($startDate, $endDate);
            }
            $this->load->view('sadmin/logintracking', $data);
        } else {
            redirect('superadmin/login');
        }
    }

    public function changepassword($datat) {
        if ($this->session->userdata('sadmin_code')) {
            if ($this->input->post()) {

                $data['msg'] = "";
                $sadminid = $this->input->post('sadminid');
                $oldsadminpassword = $this->input->post('oldsadminpassword');
                $newsadminpassword = $this->input->post('newsadminpassword');
                $cnewsadminpassword = $this->input->post('cnewsadminpassword');
                $this->load->library('form_validation');
                $this->form_validation->set_rules('sadminid', 'Login ID', 'trim|required');
                $this->form_validation->set_rules('oldsadminpassword', 'Password', 'trim|required');
                $this->form_validation->set_rules('newsadminpassword', 'New Password', 'trim|required');
                $this->form_validation->set_rules('cnewsadminpassword', 'Confirm New Password', 'trim|required');
                $data['sadmin_info'] = $this->Sadmin->loginInfo($sadminid, $oldsadminpassword);
                $update_password = array(
                    "password" => $newsadminpassword,
                );
                if ($cnewsadminpassword == $newsadminpassword && count($data['sadmin_info']) > 0) {
                    $this->Sadmin->changesadminpassword($sadminid, $update_password);
                    $data['msg'] = "Updated SuccesFully! ";
                } else {
                    if ($cnewsadminpassword != $newsadminpassword)
                        $data['msg'] = "New Password And Confirm New Password Not Match ";
                    if (!count($data['sadmin_info']) > 0)
                        $data['msg'] = "Super Admin Id And Password Not Match";
                }
            }else {
                $data['msg'] = "";
            }
            $this->load->view('sadmin/changepassword', $data);
        } else {
            redirect('superadmin/login');
        }
    }

    public function logout() {
        $this->session->unset_userdata('sadmin_code');
        redirect('superadmin/login');
    }

}
