<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');
/**
 * CodeIgniter
 *
 * An open source application development framework for PHP 4.3.2 or newer
 *
 * @package		CodeIgniter
 * @author		ExpressionEngine Dev Team
 * @copyright	Copyright (c) 2008 - 2009, EllisLab, Inc.
 * @license		http://codeigniter.com/user_guide/license.html
 * @link		http://codeigniter.com
 * @since		Version 1.0
 * @filesource
 */
// ------------------------------------------------------------------------

/**
 * CodeIgniter Reprice Helpers
 *
 * @package		CodeIgniter
 * @subpackage	Helpers
 * @category	Helpers
 * @author		ExpressionEngine Dev Team
 * @link		http://codeigniter.com/user_guide/helpers/reprice_helper.html
 */
// ------------------------------------------------------------------------

function getEmailTemplateByType2($emailType) {
    $CI = & get_instance();
    $sqlQuery = "SELECT * FROM email_templates et WHERE et.title = '" . $emailType . "' LIMIT 1";
    $sqlResult = $CI->db->query($sqlQuery)->row_array();
    
    return $sqlResult;
}

if (!function_exists('send_email_from_template')) {

    function template_email_send($template_type, $emailData) {
      
        $CI = & get_instance();
        $result_template = getEmailTemplateByType2($template_type);
        switch ($template_type) {
            case 'fpassword':
                $patterns = array(
                    '{USER_CODE}' => $emailData['user_code'],
                    '{VERIFICATION_URL}' => '<a href="' . $emailData['link'] . '">here</a>'
                );
                break;
            case 'signUp':

                $patterns = array(
                    '{FLYUP_DATE}' => date('y-m-d'),
                    '{FLYUP_NAME}' => $emailData['user_name'],
                    '{FLYUP_CODE}' => $emailData['user_code'],
                    '{FLYUP_PIN}' => $emailData['pin'],
                    '{FLYUP_PASSWORD}' => $emailData['password'],
                    '{FLYUP_MOBILE}' => $emailData['mobile_no'],
                    '{FLYUP_PRICE}' => $emailData['price']
                );
                break;
            case 'transfer':

                $patterns = array(
                    '{USER_CODE2}' => $emailData['myCode'],
                    '{USER_CODE}' => $emailData['user_code'],
                    '{AMOUNT}' => $emailData['amount']
                );
                break;
            case 'renew':
                $patterns = array(
                    '{USER_CODE2}' => $emailData['myCode'],
                    '{USER_CODE}' => $emailData['user_code'],
                    '{AMOUNT}' => $emailData['amount']
                );
                break;
            case 'emailChange':
                $patterns = array(
                    '{USER_CODE}' => $emailData['user_code'],
                    '{EMAIL_CHANGE}' => $emailData['email'],
                );
                break;
            case 'passwordChange':
             
                $patterns = array(
                    '{USER_CODE}' => $emailData['user_code'],
                    '{PASSWORD_CHANGE}' => $emailData['password'],
                );
                break;
            case 'pinChange':
             
                $patterns = array(
                    '{USER_CODE}' => $emailData['user_code'],
                    '{PIN_CHANGE}' => $emailData['pin'],
                );
                break;
        }
        if ($result_template) {

            $body = replicateDataInBody($result_template['body'], $patterns);
            $recipient = $emailData['email'];

            $sendgridUserName = 'team@flyup.pk';
            $sendgridPassword = 't@123eam';
            $CI->load->library('email');
            $CI->email->initialize(array(
                'protocol' => 'smtp',
                'smtp_host' => 'ssl://smtp.gmail.com',
                'smtp_user' => $sendgridUserName,
                'smtp_pass' => $sendgridPassword,
                'smtp_port' => 465,
                'crlf' => "\r\n",
                'newline' => "\r\n",
                'mailtype' => "html"
            ));

            $CI->email->from($result_template['from_email'], 'FlyUp');
            $CI->email->to($recipient);
            $subject = replicateDataInBody($result_template['subject'], $patterns);
            $CI->email->subject($subject);
            $CI->email->message($body);
            try {
                $CI->email->send();
//                                echo $CI->email->print_debugger();
            } catch (Exception $ex) {
                
            }
        }
    }

}

if (!function_exists('replicateDataInBody')) {

    function replicateDataInBody($body, $data_keys) {
        foreach ($data_keys as $key => $value) {
            $body = str_replace($key, $value, $body);
        }

        return $body;
    }

}


/* End of file email_helper.php */
/* Location: ./system/helpers/email_helper.php */