<?php //OCMX Custom logo and Favicon

function ocmx_logo_register($wp_customize){
    
    $wp_customize->add_section('ocmx_general', array(
        'title'    => __('General Theme Settings', 'ocmx'),
        'priority' => 30,
    ));
    
   //Custom Colors
	
	$wp_customize->add_setting('ocmx_ignore_colours', array(
        'default'        => 'no',
        'capability'     => 'edit_theme_options',
        'type'           => 'option',
    ));

    $wp_customize->add_control('header_color_scheme', array(
        'label'      => __('Use Theme Default Color Scheme', 'ocmx'),
        'section'    => 'ocmx_general',
        'settings'   => 'ocmx_ignore_colours',
        'type'       => 'radio',
        'priority' => 0,
        'choices'    => array(
            'yes' => 'Yes',
            'no' => 'No'
        ),
    ));
 
    $wp_customize->add_setting('ocmx_custom_logo', array(
        'default'           => '',
        'capability'        => 'edit_theme_options',
        'type'           => 'option',

    ));

    $wp_customize->add_control( new WP_Customize_Image_Control($wp_customize, 'ocmx_custom_logo', array(
        'label'    => __('Custom Logo', 'ocmx'),
        'section'  => 'ocmx_general',
        'settings' => 'ocmx_custom_logo',
    )));
    
    $wp_customize->add_setting('ocmx_custom_favicon', array(
        'default'           => '',
        'capability'        => 'edit_theme_options',
        'type'           => 'option',

    ));

    $wp_customize->add_control( new WP_Customize_Image_Control($wp_customize, 'ocmx_custom_favicon', array(
        'label'    => __('Custom Favicon', 'ocmx'),
        'section'  => 'ocmx_general',
        'settings' => 'ocmx_custom_favicon',
    )));
    
}

add_action('customize_register', 'ocmx_logo_register');

// OCMX Color Options 

function ocmx_customize_register($wp_customize) {


	// Header Color Scheme
	$wp_customize->add_section('header_color_scheme', array(
		'title' => __( 'Header Color Scheme', 'ocmx' ),
		'priority' => 35,
		)
	);

	$wp_customize->add_setting( 'ocmx_header_color', array(
		'default' => '#222222',
		'type' => 'option',
		'capability' => 'edit_theme_options',
		'transport' => 'postMessage',
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'ocmx_header_color', array(
		'label' => __( 'Header Background Color', 'ocmx' ),
		'section' => 'header_color_scheme',
		'settings' => 'ocmx_header_color',
		'priority' => 1,
	)));
	
	$wp_customize->add_setting( 'ocmx_navigation_links', array(
		'default' => '#86C045',
		'type' => 'option',
		'capability' => 'edit_theme_options',
		'transport' => 'postMessage',
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'ocmx_navigation_links', array(
		'label' => __( 'Navigation Links', 'ocmx' ),
		'section' => 'header_color_scheme',
		'settings' => 'ocmx_navigation_links',
		'priority' => 5,
	)));
	
	$wp_customize->add_setting( 'ocmx_navigation_links_hover', array(
		'default' => '#FFFFFF',
		'type' => 'option',
		'capability' => 'edit_theme_options',
		'transport' => 'postMessage',
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'ocmx_navigation_links_hover', array(
		'label' => __( 'Navigation Links Hover', 'ocmx' ),
		'section' => 'header_color_scheme',
		'settings' => 'ocmx_navigation_links_hover',
		'priority' => 10,
	)));
	
	$wp_customize->add_setting( 'ocmx_navigation_hover', array(
		'default' => '#3d546c',
		'type' => 'option',
		'capability' => 'edit_theme_options',
		'transport' => 'postMessage',
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'ocmx_navigation_hover', array(
		'label' => __( 'Menu Background Hover', 'ocmx' ),
		'section' => 'header_color_scheme',
		'settings' => 'ocmx_navigation_hover',
		'priority' => 11,
	)));
	
	
	// Content Color Scheme
	$wp_customize->add_section('content_color_scheme', array(
		'title' => __( 'Content Color Scheme', 'ocmx' ),
		'priority' => 36
		)
	);
	
	$wp_customize->add_setting( 'ocmx_body_links', array(
		'default' => '#86C045',
		'type' => 'option',
		'capability' => 'edit_theme_options',
		'transport' => 'postMessage',
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'ocmx_body_links', array(
		'label' => __( 'General Link Color', 'ocmx' ),
		'section' => 'content_color_scheme',
		'settings' => 'ocmx_body_links',
		'priority' => 40,
	)));
	
	$wp_customize->add_setting( 'ocmx_body_links_hover', array(
		'default' => '#333333',
		'type' => 'option',
		'capability' => 'edit_theme_options',
		'transport' => 'postMessage',
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'ocmx_body_links_hover', array(
		'label' => __( 'General Link Color Hover', 'ocmx' ),
		'section' => 'content_color_scheme',
		'settings' => 'ocmx_body_links_hover',
		'priority' => 45,
	)));
	
	$wp_customize->add_setting( 'ocmx_border_color', array(
		'default' => '#253F58',
		'type' => 'option',
		'capability' => 'edit_theme_options',
		'transport' => 'postMessage',
	));
	
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'ocmx_border_color', array(
		'label' => __( 'Border Colors', 'ocmx' ),
		'section' => 'content_color_scheme',
		'settings' => 'ocmx_border_color',
		'priority' => 47,
	)));
	
		$wp_customize->add_setting( 'ocmx_widget_titles', array(
		'default' => '#333333',
		'type' => 'option',
		'capability' => 'edit_theme_options',
		'transport' => 'postMessage',
	));
	
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'ocmx_widget_titles', array(
		'label' => __( 'Widget Titles', 'ocmx' ),
		'section' => 'content_color_scheme',
		'settings' => 'ocmx_widget_titles',
		'priority' => 48,
	)));
	
		
	
	// Footer Color Scheme
	$wp_customize->add_section('footer_color_scheme', array(
		'title' => __( 'Footer Color Scheme', 'ocmx' ),
		'priority' => 37,
		)
	);
	
	$wp_customize->add_setting( 'ocmx_footer_nav_links', array(
		'default' => '#FFFFFF',
		'type' => 'option',
		'capability' => 'edit_theme_options',
		'transport' => 'postMessage',
	));
	
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'ocmx_footer_nav_links', array(
		'label' => __( 'Footer Links Color', 'ocmx' ),
		'section' => 'footer_color_scheme',
		'settings' => 'ocmx_footer_nav_links',
		'priority' => 50,
	)));
	
	$wp_customize->add_setting( 'ocmx_footer_links_hover', array(
		'default' => '#FFCC00',
		'type' => 'option',
		'capability' => 'edit_theme_options',
		'transport' => 'postMessage',
	));
	
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'ocmx_footer_links_hover', array(
		'label' => __( 'Footer Links Hover Color', 'ocmx' ),
		'section' => 'footer_color_scheme',
		'settings' => 'ocmx_footer_links_hover',
		'priority' => 55,
	)));
	
	$wp_customize->add_setting( 'ocmx_footer_text', array(
		'default' => '#999999',
		'type' => 'option',
		'capability' => 'edit_theme_options',
		'transport' => 'postMessage',
	));
	
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'ocmx_footer_text', array(
		'label' => __( 'Footer Text Color', 'ocmx' ),
		'section' => 'footer_color_scheme',
		'settings' => 'ocmx_footer_text',
		'priority' => 55,
	)));
	
	$wp_customize->add_setting( 'ocmx_footer_background', array(
		'default' => '#333333',
		'type' => 'option',
		'capability' => 'edit_theme_options',
		'transport' => 'postMessage',
	));
	
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'ocmx_footer_background', array(
		'label' => __( 'Footer Background Color', 'ocmx' ),
		'section' => 'footer_color_scheme',
		'settings' => 'ocmx_footer_background',
		'priority' => 60,
	)));
	
	wp_reset_query();

//ADD JQUERY

if ( $wp_customize->is_preview() && ! is_admin() )
	add_action( 'wp_footer', 'ocmx_customize_preview', 21);
	
	function ocmx_customize_preview() {
	?>
	<script type="text/javascript">

	( function( $ ){
	
		wp.customize('ocmx_header_color',function( value ) {
			value.bind(function(to) {
				jQuery('#header-container, .sub-menu').css({'backgroundColor': to});
			});
		});
		
		wp.customize('ocmx_navigation_links',function( value ) {
			value.bind(function(to) {
				jQuery('.page-menu a').css({'color': to});
			});
		});

		wp.customize('ocmx_navigation_links_hover',function( value ) {
			value.bind(function(to) {
				jQuery('.page-menu a:hover, .page-menu .current_page_item a').css({'color': to});
			});
		});
		
		wp.customize('ocmx_navigation_hover',function( value ) {
			value.bind(function(to) {
				jQuery('.page-menu .current_page_item, .page-menu a:hover, input[type="button"], input[type="submit"], input[type="button"]:hover, input[type="submit"]:hover').css({'backgroundColor': to});
			});
		});
		
		wp.customize('ocmx_body_links',function( value ) {
			value.bind(function(to) {
				jQuery('.link-post-link a, .post a, #right-column a, .meta a').css({'color': to});
			});
		});
		
		wp.customize('ocmx_body_links_hover',function( value ) {
			value.bind(function(to) {
				jQuery('.link-post-link a:hover, .post a:hover, #right-column a:hover, .meta a:hover, ').css({'color': to});
			});
		});
		
		wp.customize('ocmx_widget_titles',function( value ) {
			value.bind(function(to) {
				jQuery('.widgettitle, h3.widgettitle a').css({'color': to});
			});
		});
		
		wp.customize('ocmx_footer_nav_links',function( value ) {
			value.bind(function(to) {
				jQuery('#footer a').css({'color': to});
			});
		});
		
		wp.customize('ocmx_footer_links_hover',function( value ) {
			value.bind(function(to) {
				jQuery('#footer a:hover, .obox-credit a:hover').css({'color': to});
			});
		});
		
		wp.customize('ocmx_footer_text',function( value ) {
			value.bind(function(to) {
				jQuery('#footer, #footer ul li.column ul li, .footer-text').css({'color': to});
			});
		});
		
		wp.customize('ocmx_footer_background',function( value ) {
			value.bind(function(to) {
				jQuery('#footer-container').css({'backgroundColor': to});
			});
		});
		
		wp.customize('ocmx_border_color',function( value ) {
			value.bind(function(to) {
				jQuery('.post .post-image img').css({'backgroundColor': to});
			});
		});
	
	} )( jQuery );
	</script>
<?php } 

//ADD POST MESSAGE

$wp_customize->get_setting('ocmx_header_color')->transport='postMessage';
$wp_customize->get_setting('ocmx_navigation_links')->transport='postMessage';
$wp_customize->get_setting('ocmx_navigation_links_hover')->transport='postMessage';
$wp_customize->get_setting('ocmx_navigation_hover')->transport='postMessage';
$wp_customize->get_setting('ocmx_body_links_hover')->transport='postMessage';
$wp_customize->get_setting('ocmx_body_links')->transport='postMessage';
$wp_customize->get_setting('ocmx_widget_titles')->transport='postMessage';
$wp_customize->get_setting('ocmx_footer_background')->transport='postMessage';
$wp_customize->get_setting('ocmx_footer_nav_links')->transport='postMessage';
$wp_customize->get_setting('ocmx_footer_links_hover')->transport='postMessage';
$wp_customize->get_setting('ocmx_footer_text')->transport='postMessage';
$wp_customize->get_setting('ocmx_border_color')->transport='postMessage';
}
add_action( 'customize_register', 'ocmx_customize_register' );

function ocmx_add_query_vars($query_vars) {
	$query_vars[] = 'stylesheet';
	return $query_vars;
}
add_filter( 'query_vars', 'ocmx_add_query_vars' );
function ocmx_takeover_css() {
	    $style = get_query_var('stylesheet');
	    if($style == "custom") {
		    include_once(TEMPLATEPATH . '/style.php');
	        exit;
	    }
	}
add_action( 'template_redirect', 'ocmx_takeover_css');