<?php
/**
 * Visual Composer Heading
 *
 * @package Total Theme Core
 * @subpackage WPBakery
 * @version 1.0.3
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'VCEX_Heading_Shortcode' ) ) {

	class VCEX_Heading_Shortcode {

		/**
		 * Define shortcode name.
		 */
		public $shortcode = 'vcex_heading';

		/**
		 * Main constructor.
		 */
		public function __construct() {
			add_shortcode( $this->shortcode, array( $this, 'output' ) );
			add_action( 'vc_after_mapping', array( $this, 'vc_after_mapping' ) );
		}

		/**
		 * Adds scripts for custom module view.
		 */
		public function admin_print_scripts() {
			if ( 'post' != get_current_screen()->base ) {
				return false;
			}
			wp_enqueue_script(
				'vcex-js-view',
				vcex_asset_url( 'js/backend/vcex-js-view.min.js' ),
				array( 'jquery' ),
				'1.0',
				true
			);
		}

		/**
		 * Shortcode output => Get template file and display shortcode.
		 */
		public function output( $atts, $content = null ) {
			ob_start();
			include( vcex_get_shortcode_template( $this->shortcode ) );
			return ob_get_clean();
		}

		/**
		 * VC functions.
		 */
		public function vc_after_mapping() {
			vc_lean_map( $this->shortcode, array( $this, 'map' ) );
			add_action( 'admin_print_scripts', array( $this, 'admin_print_scripts' ), 999 );
		}

		/**
		 * Map shortcode to VC.
		 */
		public function map() {
			return array(
				'name' => esc_html__( 'Heading', 'total-theme-core' ),
				'description' => esc_html__( 'A better heading module', 'total-theme-core' ),
				'base' => $this->shortcode,
				'category' => vcex_shortcodes_branding(),
				'icon' => 'vcex-heading vcex-icon ticon ticon-font',
				'js_view' => 'VcexHeadingView',
				'params' => array(
					// General
					array(
						'type' => 'dropdown',
						'heading' => esc_html__( 'Text Source', 'total-theme-core' ),
						'param_name' => 'source',
						'value' => array(
							esc_html__( 'Custom Text', 'total-theme-core' ) => 'custom',
							esc_html__( 'Post or Page Title', 'total-theme-core' ) => 'post_title',
							esc_html__( 'Post Publish Date', 'total-theme-core' ) => 'post_date',
							esc_html__( 'Post Modified Date', 'total-theme-core' ) => 'post_modified_date',
							esc_html__( 'Post Author', 'total-theme-core' ) => 'post_author',
							esc_html__( 'Current User', 'total-theme-core' ) => 'current_user',
							esc_html__( 'Custom Field', 'total-theme-core' ) => 'custom_field',
							esc_html__( 'Callback Function', 'total-theme-core' ) => 'callback_function',
						),
						'admin_label' => true,
					),
					array(
						'type' => 'textfield',
						'heading' => esc_html__( 'Custom Field ID', 'total-theme-core' ),
						'param_name' => 'custom_field',
						'dependency' => array( 'element' => 'source', 'value' => 'custom_field' ),
					),
					array(
						'type' => 'textfield',
						'heading' => esc_html__( 'Callback Function', 'total-theme-core' ),
						'param_name' => 'callback_function',
						'dependency' => array( 'element' => 'source', 'value' => 'callback_function' ),
					),
					array(
						'type' => 'textarea_safe',
						'heading' => esc_html__( 'Text', 'total-theme-core' ),
						'param_name' => 'text',
						'value' => esc_html__( 'Heading', 'total-theme-core' ),
						'vcex_rows' => 2,
						'description' => esc_html__( 'HTML Supported', 'total-theme-core' ),
						'dependency' => array( 'element' => 'source', 'value' => 'custom' ),
					),
					array(
						'type' => 'vcex_select_buttons',
						'heading' => esc_html__( 'Style', 'total-theme-core' ),
						'param_name' => 'style',
						'std' => 'plain',
						'choices' => array(
							'plain' => esc_html__( 'Plain', 'total-theme-core' ),
							'bottom-border-w-color' => esc_html__( 'Border', 'total-theme-core' ),
							'graphical' => esc_html__( 'Graphical', 'total-theme-core' ),
						),
					),
					array(
						'type' => 'colorpicker',
						'heading' => esc_html__( 'Accent Border Color', 'total-theme-core' ),
						'param_name' => 'inner_bottom_border_color',
						'dependency' => array( 'element' => 'style', 'value' => 'bottom-border-w-color' ),
					),
					array(
						'type' => 'colorpicker',
						'heading' => esc_html__( 'Border Color', 'total-theme-core' ),
						'param_name' => 'inner_bottom_border_color_main',
						'dependency' => array( 'element' => 'style', 'value' => 'bottom-border-w-color' ),
					),
					array(
						'type' => 'textfield',
						'heading' => esc_html__( 'Width', 'total-theme-core' ),
						'param_name' => 'width',
						'description' => esc_html__( 'Enter a custom width instead of using breaks to slim down your content width.', 'total-theme-core' ),
					),
					array(
						'type' => 'vcex_text_alignments',
						'heading' => esc_html__( 'Module Align', 'total-theme-core' ),
						'param_name' => 'align',
						'std' => '',
						'dependency' => array( 'element' => 'width', 'not_empty' => true ),
					),
					array(
						'type' => 'vcex_visibility',
						'heading' => esc_html__( 'Visibility', 'total-theme-core' ),
						'param_name' => 'visibility',
					),
					array(
						'type' => 'textfield',
						'heading' => esc_html__( 'Extra class name', 'total-theme-core' ),
						'param_name' => 'el_class',
						'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'total-theme-core' ),
					),
					vcex_vc_map_add_css_animation(),
					// Typography
					array(
						'type' => 'vcex_notice',
						'param_name' => 'typo_notice',
						'text' => esc_html__( 'You can set custom styles for your this specific heading module below but you can also go to Appearance > Customize > Typography to set global styles for all your heading modules.', 'total-theme-core' ),
						'group' => esc_html__( 'Typography', 'total-theme-core' ),
					),
					array(
						'type' => 'vcex_font_family_select',
						'heading' => esc_html__( 'Font Family', 'total-theme-core' ),
						'param_name' => 'font_family',
						'group' => esc_html__( 'Typography', 'total-theme-core' ),
					),
					array(
						'type' => 'vcex_font_weight',
						'heading' => esc_html__( 'Font Weight', 'total-theme-core' ),
						'param_name' => 'font_weight',
						'group' => esc_html__( 'Typography', 'total-theme-core' ),
					),
					array(
						'type' => 'vcex_text_transforms',
						'heading' => esc_html__( 'Text Transform', 'total-theme-core' ),
						'param_name' => 'text_transform',
						'group' => esc_html__( 'Typography', 'total-theme-core' ),
					),
					array(
						'type' => 'vcex_text_alignments',
						'heading' => esc_html__( 'Text Align', 'total-theme-core' ),
						'param_name' => 'text_align',
						'group' => esc_html__( 'Typography', 'total-theme-core' ),
					),
					array(
						'heading' => esc_html__( 'Tag', 'total-theme-core' ),
						'param_name' => 'tag',
						'type' => 'vcex_select_buttons',
						'choices' => 'html_tag',
						'group' => esc_html__( 'Typography', 'total-theme-core' ),
						'description' => esc_html__( 'Default tag is "div" and can be altered via a simple filter in your child theme.', 'total-theme-core' ),
					),
					array(
						'type' => 'colorpicker',
						'heading' => esc_html__( 'Color', 'total-theme-core' ),
						'param_name' => 'color',
						'group' => esc_html__( 'Typography', 'total-theme-core' ),
					),
					array(
						'type' => 'colorpicker',
						'heading' => esc_html__( 'Color: Hover', 'total-theme-core' ),
						'param_name' => 'color_hover',
						'group' => esc_html__( 'Typography', 'total-theme-core' ),
					),
					array(
						'type' => 'vcex_responsive_sizes',
						'heading' => esc_html__( 'Font Size', 'total-theme-core' ),
						'param_name' => 'font_size',
						'description' => esc_html__( 'You can enter a px or em value. Example 13px or 1em.', 'total-theme-core' ),
						'group' => esc_html__( 'Typography', 'total-theme-core' ),
						'target' => 'font-size',
					),
					array(
						'type' => 'vcex_ofswitch',
						'std' => 'false',
						'heading' => esc_html__( 'Auto Responsive Font Size', 'total-theme-core' ),
						'param_name' => 'responsive_text',
						'group' => esc_html__( 'Typography', 'total-theme-core' ),
					),
					array(
						'type' => 'textfield',
						'heading' => esc_html__( 'Minimum Font Size', 'total-theme-core' ),
						'param_name' => 'min_font_size',
						'dependency' => array( 'element' => 'responsive_text', 'value' => 'true' ),
						'group' => esc_html__( 'Typography', 'total-theme-core' ),
					),
					array(
						'type' => 'textfield',
						'heading' => esc_html__( 'Line Height', 'total-theme-core' ),
						'param_name' => 'line_height',
						'group' => esc_html__( 'Typography', 'total-theme-core' ),
					),
					array(
						'type' => 'textfield',
						'heading' => esc_html__( 'Letter Spacing', 'total-theme-core' ),
						'param_name' => 'letter_spacing',
						'group' => esc_html__( 'Typography', 'total-theme-core' ),
					),
					array(
						'type' => 'vcex_ofswitch',
						'std' => 'false',
						'heading' => esc_html__( 'Italic', 'total-theme-core' ),
						'param_name' => 'italic',
						'group' => esc_html__( 'Typography', 'total-theme-core' ),
					),
					// Link
					array(
						'type' => 'vc_link',
						'heading' => esc_html__( 'URL', 'total-theme-core' ),
						'param_name' => 'link',
						'group' => esc_html__( 'Link', 'total-theme-core' ),
					),
					array(
						'type' => 'vcex_ofswitch',
						'std' => 'false',
						'heading' => esc_html__( 'Link: Local Scroll', 'total-theme-core' ),
						'param_name' => 'link_local_scroll',
						'group' => esc_html__( 'Link', 'total-theme-core' ),
					),
					// Icon
					array(
						'type' => 'dropdown',
						'heading' => esc_html__( 'Icon library', 'total-theme-core' ),
						'param_name' => 'icon_type',
						'description' => esc_html__( 'Select icon library.', 'total-theme-core' ),
						'value' => array(
							esc_html__( 'Font Awesome', 'total-theme-core' ) => 'fontawesome',
							esc_html__( 'Open Iconic', 'total-theme-core' ) => 'openiconic',
							esc_html__( 'Typicons', 'total-theme-core' ) => 'typicons',
							esc_html__( 'Entypo', 'total-theme-core' ) => 'entypo',
							esc_html__( 'Linecons', 'total-theme-core' ) => 'linecons',
							esc_html__( 'Material', 'total-theme-core' ) => 'material',
							esc_html__( 'Pixel', 'total-theme-core' ) => 'pixelicons',
						),
						'group' => esc_html__( 'Icon', 'total-theme-core' ),
					),
					array(
						'type' => 'iconpicker',
						'heading' => esc_html__( 'Icon', 'total-theme-core' ),
						'param_name' => 'icon',
						'value' => '',
						'settings' => array(
							'emptyIcon' => true,
							'iconsPerPage' => 4000,
						),
						'dependency' => array( 'element' => 'icon_type', 'value' => 'fontawesome' ),
						'group' => esc_html__( 'Icon', 'total-theme-core' ),
					),
					array(
						'type' => 'iconpicker',
						'heading' => esc_html__( 'Icon', 'total-theme-core' ),
						'param_name' => 'icon_openiconic',
						'settings' => array(
							'emptyIcon' => true,
							'type' => 'openiconic',
							'iconsPerPage' => 4000,
						),
						'dependency' => array( 'element' => 'icon_type', 'value' => 'openiconic' ),
						'group' => esc_html__( 'Icon', 'total-theme-core' ),
					),
					array(
						'type' => 'iconpicker',
						'heading' => esc_html__( 'Icon', 'total-theme-core' ),
						'param_name' => 'icon_typicons',
						'settings' => array(
							'emptyIcon' => true,
							'type' => 'typicons',
							'iconsPerPage' => 4000,
						),
						'dependency' => array( 'element' => 'icon_type', 'value' => 'typicons' ),
						'group' => esc_html__( 'Icon', 'total-theme-core' ),
					),
					array(
						'type' => 'iconpicker',
						'heading' => esc_html__( 'Icon', 'total-theme-core' ),
						'param_name' => 'icon_entypo',
						'settings' => array(
							'emptyIcon' => true,
							'type' => 'entypo',
							'iconsPerPage' => 300,
						),
						'dependency' => array( 'element' => 'icon_type', 'value' => 'entypo' ),
						'group' => esc_html__( 'Icon', 'total-theme-core' ),
					),
					array(
						'type' => 'iconpicker',
						'heading' => esc_html__( 'Icon', 'total-theme-core' ),
						'param_name' => 'icon_linecons',
						'settings' => array(
							'emptyIcon' => true,
							'type' => 'linecons',
							'iconsPerPage' => 4000,
						),
						'dependency' => array( 'element' => 'icon_type', 'value' => 'linecons' ),
						'group' => esc_html__( 'Icon', 'total-theme-core' ),
					),
					array(
						'type' => 'iconpicker',
						'heading' => esc_html__( 'Icon', 'total-theme-core' ),
						'param_name' => 'icon_material',
						'settings' => array(
							'emptyIcon' => true,
							'type' => 'material',
							'iconsPerPage' => 4000,
						),
						'dependency' => array( 'element' => 'icon_type', 'value' => 'material' ),
						'group' => esc_html__( 'Icon', 'total-theme-core' ),
					),
					array(
						'type' => 'iconpicker',
						'heading' => esc_html__( 'Icon', 'total-theme-core' ),
						'param_name' => 'icon_pixelicons',
						'settings' => array(
							'emptyIcon' => true,
							'type' => 'pixelicons',
							'source' => vcex_pixel_icons(),
						),
						'dependency' => array( 'element' => 'icon_type', 'value' => 'pixelicons' ),
						'group' => esc_html__( 'Icon', 'total-theme-core' ),
					),
					array(
						'type' => 'vcex_select_buttons',
						'heading' => esc_html__( 'Position', 'total-theme-core' ),
						'param_name' => 'icon_position',
						'std' => 'left',
						'choices' => array(
							'left' => esc_html__( 'Left', 'total-theme-core' ),
							'right' => esc_html__( 'Right', 'total-theme-core' ),
						),
						'group' => esc_html__( 'Icon', 'total-theme-core' ),
					),
					array(
						'type' => 'colorpicker',
						'heading' => esc_html__( 'Color', 'total-theme-core' ),
						'param_name' => 'icon_color',
						'group' => esc_html__( 'Icon', 'total-theme-core' ),
					),

					// Design
					array(
						'type' => 'css_editor',
						'heading' => esc_html__( 'CSS', 'total-theme-core' ),
						'param_name' => 'css',
						'group' => esc_html__( 'Design', 'total-theme-core' ),
					),
					array(
						'type' => 'vcex_ofswitch',
						'std' => 'false',
						'heading' => esc_html__( 'Add Design to Inner Span', 'total-theme-core' ),
						'param_name' => 'add_css_to_inner',
						'group' => esc_html__( 'Design', 'total-theme-core' ),
						'description' => esc_html__( 'Enable to add the background, padding, border, etc only around your text and icons and not the whole heading container.', 'total-theme-core' ),
						'dependency' => array( 'element' => 'style', 'value' => 'plain' ),
					),
					array(
						'type' => 'colorpicker',
						'heading' => esc_html__( 'Background: Hover', 'total-theme-core' ),
						'param_name' => 'background_hover',
						'group' => esc_html__( 'Design', 'total-theme-core' ),
						'dependency' => array( 'element' => 'style', 'value' => 'plain' ),
					),
					array(
						'type' => 'vcex_ofswitch',
						'heading' => esc_html__( 'White Text On Hover', 'total-theme-core' ),
						'param_name' => 'hover_white_text',
						'std' => 'false',
						'group' => esc_html__( 'Design', 'total-theme-core' ),
						'dependency' => array( 'element' => 'style', 'value' => 'plain' ),
					),
				)

			);
		}

	}
}
new VCEX_Heading_Shortcode;

if ( class_exists( 'WPBakeryShortCode' ) ) {
	class WPBakeryShortCode_vcex_heading extends WPBakeryShortCode {
		protected function outputTitle( $title ) {
			$icon = $this->settings( 'icon' );
			return '<h4 class="wpb_element_title"><i class="vc_general vc_element-icon' . ( ! empty( $icon ) ? ' ' . $icon : '' ) . '"></i><span class="vcex-heading-text">' . esc_html__( 'Heading', 'total-theme-core' ) . '<span></span></span></span></h4>';
		}
	}
}