<?php
/**
 * Child theme functions
 *
 * When using a child theme (see http://codex.wordpress.org/Theme_Development
 * and http://codex.wordpress.org/Child_Themes), you can override certain
 * functions (those wrapped in a function_exists() call) by defining them first
 * in your child theme's functions.php file. The child theme's functions.php
 * file is included before the parent theme's file, so the child theme
 * functions would be used.
 *
 * Text Domain: wpex
 * @link http://codex.wordpress.org/Plugin_API
 *
 */

/**
 * Load the parent style.css file
 *
 * @link http://codex.wordpress.org/Child_Themes
 */
function total_child_enqueue_parent_theme_style() {

	// Dynamically get version number of the parent stylesheet (lets browsers re-cache your stylesheet when you update your theme)
	$theme   = wp_get_theme( 'Total' );
	$version = $theme->get( 'Version' );

	// Load the stylesheet
	wp_enqueue_style( 'parent-style', get_template_directory_uri() . '/style.css', array(), $version );

}
add_action( 'wp_enqueue_scripts', 'total_child_enqueue_parent_theme_style' );

// Add custom font to font settings
function wpex_add_custom_fonts() {
	return array( 'Product Sans','product_sansregular','product_sansbold' ); // You can add more then 1 font to the array!
	
}



// Register Custom Post Type
function openinig_jobs() {
	
    $labels = array(
        'name' => _x('Openinig Jobs', 'Post Type General Name', 'html5blank'),
        'singular_name' => _x('Openinig Job', 'Post Type Singular Name', 'html5blank'),
        'menu_name' => __('Openinig Jobs', 'html5blank'),
        'name_admin_bar' => __('Openinig Jobs', 'html5blank'),
        'archives' => __('Item Archives', 'html5blank'),
        'attributes' => __('Item Attributes', 'html5blank'),
        'parent_item_colon' => __('Parent Item:', 'html5blank'),
        'all_items' => __('All Jobs', 'html5blank'),
        'add_new_item' => __('Add New Job', 'html5blank'),
        'add_new' => __('Add New', 'html5blank'),
        'new_item' => __('New Item', 'html5blank'),
        'edit_item' => __('Edit Item', 'html5blank'),
        'update_item' => __('Update Item', 'html5blank'),
        'view_item' => __('View Item', 'html5blank'),
        'view_items' => __('View Items', 'html5blank'),
        'search_items' => __('Search Item', 'html5blank'),
        'not_found' => __('Not found', 'html5blank'),
        'not_found_in_trash' => __('Not found in Trash', 'html5blank'),
        'featured_image' => __('Featured Image', 'html5blank'),
        'set_featured_image' => __('Set featured image', 'html5blank'),
        'remove_featured_image' => __('Remove featured image', 'html5blank'),
        'use_featured_image' => __('Use as featured image', 'html5blank'),
        'insert_into_item' => __('Insert into item', 'html5blank'),
        'uploaded_to_this_item' => __('Uploaded to this item', 'html5blank'),
        'items_list' => __('Items list', 'html5blank'),
        'items_list_navigation' => __('Items list navigation', 'html5blank'),
        'filter_items_list' => __('Filter items list', 'html5blank'),
        'taxonomies' => array('category', 'post_tag'),
    );
    $args = array(
        'label' => __('Openinig Jobs', 'html5blank'),
        'description' => __('Jobs of Pie', 'html5blank'),
        'labels' => $labels,
        'supports' => array('title', 'editor', 'thumbnail'),
        // 'taxonomies' => array('category', 'post_tag'),
        'hierarchical' => false,
        'public' => true,
        'show_ui' => true,
        'show_in_menu' => true,
        'menu_position' => 5,
        'menu_icon' => 'dashicons-admin-users',
        'show_in_admin_bar' => true,
        'show_in_nav_menus' => true,
        'can_export' => true,
        'has_archive' => true,
        'exclude_from_search' => false,
        'publicly_queryable' => true,
        'capability_type' => 'post',
    );
    register_taxonomy("categories", array("openinig_jobs"), array("hierarchical" => true, "label" => "Job Categories", "singular_label" => "Category", "rewrite" => array( 'slug' => 'openinig_jobs', 'with_front'=> true )));
    register_post_type('openinig_jobs', $args);


}

add_action('init', 'openinig_jobs', 0);

// hide update notifications
function remove_core_updates(){
global $wp_version;return(object) array('last_checked'=> time(),'version_checked'=> $wp_version,);
}
add_filter('pre_site_transient_update_core','remove_core_updates'); //hide updates for WordPress itself
add_filter('pre_site_transient_update_plugins','remove_core_updates'); //hide updates for all plugins
add_filter('pre_site_transient_update_themes','remove_core_updates'); //hide updates for all themes

